//Written By Michael Gibson
//for Gibson Digital Enterprises
//(c) 2010 - 2025
// Originally under GPL 2
// Now GPL 3
// A command line light weight spread sheet reader for testing
// for reading gss 1.0 files

#include<stdio.h>
#include<stdlib.h>
#include<ctype.h>
#include<string.h>
#include "readdata.c"
#include "recalc.c"

int dpage=0;
int show_line_s=0;
int show_line_e=31;

FILE *fileptr;
char filenameout[32];


//////////////////////////////
//////////////////////////////
void print_screen(void){

  int subloop;

  printf("\33[2J");
  printf("\033[H\033[2J");


  if(cell_width<=7) cell_width=7;
  if(cell_width>=11) cell_width=11;

  if(column_h != 0 && column_h != 1) column_h=0;


  if(cell_width==7 && column_h==0) printf("   %sA_______B_______C_______D_______E_______F_______G_______H_______I_______J_______K_______L_______%s\n",C4A0,C7A0);
  if(cell_width==8 && column_h==0) printf("   %sA________B________C________D________E________F________G________H________I________J________K________L________%s\n",C4A0,C7A0);
  if(cell_width==9 && column_h==0) printf("   %sA_________B_________C_________D_________E_________F_________G_________H_________I_________J_________K_________L_________%s\n",C4A0,C7A0);
  if(cell_width==10 && column_h==0)printf("   %sA__________B__________C__________D__________E__________F__________G__________H__________I__________J__________K__________L__________%s\n",C4A0,C7A0);
  if(cell_width==11 && column_h==0)printf("   %sA___________B___________C___________D___________E___________F___________G___________H___________I___________J___________K___________L___________%s\n",C4A0,C7A0);


  if(cell_width==7 && column_h==1) printf("   %sA_______B_______C_______D_______E_______F_______G_______H_______I_______J_______K_______L_______%s\n",BLWH,C7A0);
  if(cell_width==8 && column_h==1) printf("   %sA________B________C________D________E________F________G________H________I________J________K________L________%s\n",BLWH,C7A0);
  if(cell_width==9 && column_h==1) printf("   %sA_________B_________C_________D_________E_________F_________G_________H_________I_________J_________K_________L_________%s\n",BLWH,C7A0);
  if(cell_width==10 && column_h==1)printf("   %sA__________B__________C__________D__________E__________F__________G__________H__________I__________J__________K__________L__________%s\n",BLWH,C7A0);
  if(cell_width==11 && column_h==1)printf("   %sA___________B___________C___________D___________E___________F___________G___________H___________I___________J___________K___________L___________%s\n",BLWH,C7A0);



  if(dpage<=0){
    dpage=0;
    show_line_s=0;
    show_line_e=31;
  }
   

  if(dpage==0){
    show_line_s=0;
    show_line_e=31;
  }

  if(dpage==1){
    show_line_s=31;
    show_line_e=62;
  }

  if(dpage==2){
    show_line_s=62;
    show_line_e=93;
  }

  if(dpage>=4){
    dpage=3;
    show_line_s=62;
    show_line_e=93;
  }



  for(subloop=show_line_s;subloop<show_line_e;subloop++){

    


    if(cell_width==7)printf("%s%2d%s|%s%7s%s|%s%7s%s|%s%7s%s|%s%7s%s|%s%7s%s|%s%7s%s|%s%7s%s|%s%7s%s|%s%7s%s|%s%7s%s|%s%7s%s|%s%7s%s|\n",
            C4A0,subloop,C7A0,
            color[0][subloop],value[0][subloop],C7A0,
            color[1][subloop],value[1][subloop],C7A0,
            color[2][subloop],value[2][subloop],C7A0,
            color[3][subloop],value[3][subloop],C7A0,
            color[4][subloop],value[4][subloop],C7A0,
            color[5][subloop],value[5][subloop],C7A0,
            color[6][subloop],value[6][subloop],C7A0,
            color[7][subloop],value[7][subloop],C7A0,
            color[8][subloop],value[8][subloop],C7A0,
            color[9][subloop],value[9][subloop],C7A0,
            color[10][subloop],value[10][subloop],C7A0,
            color[11][subloop],value[11][subloop],C7A0);


    if(cell_width==8)printf("%s%2d%s|%s%8s%s|%s%8s%s|%s%8s%s|%s%8s%s|%s%8s%s|%s%8s%s|%s%8s%s|%s%8s%s|%s%8s%s|%s%8s%s|%s%8s%s|%s%8s%s|\n",
            C4A0,subloop,C7A0,
            color[0][subloop],value[0][subloop],C7A0,
            color[1][subloop],value[1][subloop],C7A0,
            color[2][subloop],value[2][subloop],C7A0,
            color[3][subloop],value[3][subloop],C7A0,
            color[4][subloop],value[4][subloop],C7A0,
            color[5][subloop],value[5][subloop],C7A0,
            color[6][subloop],value[6][subloop],C7A0,
            color[7][subloop],value[7][subloop],C7A0,
            color[8][subloop],value[8][subloop],C7A0,
            color[9][subloop],value[9][subloop],C7A0,
            color[10][subloop],value[10][subloop],C7A0,
            color[11][subloop],value[11][subloop],C7A0);

    if(cell_width==9)printf("%s%2d%s|%s%9s%s|%s%9s%s|%s%9s%s|%s%9s%s|%s%9s%s|%s%9s%s|%s%9s%s|%s%9s%s|%s%9s%s|%s%9s%s|%s%9s%s|%s%9s%s|\n",
            C4A0,subloop,C7A0,
            color[0][subloop],value[0][subloop],C7A0,
            color[1][subloop],value[1][subloop],C7A0,
            color[2][subloop],value[2][subloop],C7A0,
            color[3][subloop],value[3][subloop],C7A0,
            color[4][subloop],value[4][subloop],C7A0,
            color[5][subloop],value[5][subloop],C7A0,
            color[6][subloop],value[6][subloop],C7A0,
            color[7][subloop],value[7][subloop],C7A0,
            color[8][subloop],value[8][subloop],C7A0,
            color[9][subloop],value[9][subloop],C7A0,
            color[10][subloop],value[10][subloop],C7A0,
            color[11][subloop],value[11][subloop],C7A0);

   if(cell_width==10)printf("%s%2d%s|%s%10s%s|%s%10s%s|%s%10s%s|%s%10s%s|%s%10s%s|%s%10s%s|%s%10s%s|%s%10s%s|%s%10s%s|%s%10s%s|%s%10s%s|%s%10s%s|\n",
            C4A0,subloop,C7A0,
            color[0][subloop],value[0][subloop],C7A0,
            color[1][subloop],value[1][subloop],C7A0,
            color[2][subloop],value[2][subloop],C7A0,
            color[3][subloop],value[3][subloop],C7A0,
            color[4][subloop],value[4][subloop],C7A0,
            color[5][subloop],value[5][subloop],C7A0,
            color[6][subloop],value[6][subloop],C7A0,
            color[7][subloop],value[7][subloop],C7A0,
            color[8][subloop],value[8][subloop],C7A0,
            color[9][subloop],value[9][subloop],C7A0,
            color[10][subloop],value[10][subloop],C7A0,
            color[11][subloop],value[11][subloop],C7A0);

   if(cell_width==11)printf("%s%2d%s|%s%11s%s|%s%11s%s|%s%11s%s|%s%11s%s|%s%11s%s|%s%11s%s|%s%11s%s|%s%11s%s|%s%11s%s|%s%11s%s|%s%11s%s|%s%11s%s|\n",
            C4A0,subloop,C7A0,
            color[0][subloop],value[0][subloop],C7A0,
            color[1][subloop],value[1][subloop],C7A0,
            color[2][subloop],value[2][subloop],C7A0,
            color[3][subloop],value[3][subloop],C7A0,
            color[4][subloop],value[4][subloop],C7A0,
            color[5][subloop],value[5][subloop],C7A0,
            color[6][subloop],value[6][subloop],C7A0,
            color[7][subloop],value[7][subloop],C7A0,
            color[8][subloop],value[8][subloop],C7A0,
            color[9][subloop],value[9][subloop],C7A0,
            color[10][subloop],value[10][subloop],C7A0,
            color[11][subloop],value[11][subloop],C7A0);


  }

}


//////////////////////////////
//////////////////////////////
int main(int argc, char *argv[])
{

int input;
int input_row;
int input_col;
int input_color=0;
int loop;
int loopx;
int loopy;
char tmpstring[99];
char bookname[44];

if(argc >=2){
  strcpy(filename,argv[1]);
  strcpy(par2,argv[2]);
}

printf("starting...");
cell_width=11;
  for(loopx=0;loopx<=93;loopx++){
    for(loopy=0;loopy<=93;loopy++){
      strcpy(valueo[loopx][loopy],"__");
      strcpy(value[loopx][loopy]," ");
      valuec1[loopx][loopy]=0;
      valuel[loopx][loopy]=0.0;
      valuen[loopx][loopy]=0;
   }
 }
printf("init complete...");

if(argc >=2){read_data();}
printf("screen start\n");
print_screen();

for(loop=0;loop<=999;loop++){

printf("[%s1%s Change/Add value]  [%s2%s Show cell value]  [3 Save to GSS file] [4] [%s5%s Page down]  [%s6%s Page up]  [7 Setup]  [%s0%s Exit] > ",C5A0,C7A0,C2A0,C7A0,C6A0,C7A0,C6A0,C7A0,C1A0,C7A0);
scanf("%d",&input);

if(input==1){
  printf("please enter row number > ");
  scanf("%d",&input_row);
  printf("Enter Column number 0=A,1=B,2=C,3=D,4=E,5=F,6=G,7=H,8=I,9=J... > ");
  scanf("%d",&input_col);
  printf("Enter Number, String, or Formula > ");
  scanf("%s",value[input_col][input_row]);
  strcpy(tmpstring,value[input_col][input_row]);
  
  if(value[input_col][input_row][0] =='0' || value[input_col][input_row][0] =='1' ||
     value[input_col][input_row][0] =='2' || value[input_col][input_row][0] =='3' ||
     value[input_col][input_row][0] =='4' || value[input_col][input_row][0] =='5' ||
     value[input_col][input_row][0] =='6' || value[input_col][input_row][0] =='7' ||
     value[input_col][input_row][0] =='8' || value[input_col][input_row][0] =='9'){
           valuel[input_col][input_row]=atof(tmpstring);
           valuen[input_col][input_row]=1;
     } 
  strcpy(valueo[input_col][input_row],value[input_col][input_row]);
    
  printf("Color: 0=white, 1=red, 2=green, 3=yellow, 4=blue , 5=magenta , 6=cyan , 7=white > ");
  scanf("%d",&input_color);
  if(input_color <=0){ input_color=0;}
  if(input_color >=7){ input_color=0;}
  if(input_color ==0) strcpy(color[input_col][input_row],C7A0);
  if(input_color ==1) strcpy(color[input_col][input_row],C1A0);
  if(input_color ==2) strcpy(color[input_col][input_row],C2A0);
  if(input_color ==3) strcpy(color[input_col][input_row],C3A0);
  if(input_color ==4) strcpy(color[input_col][input_row],C4A0);
  if(input_color ==5) strcpy(color[input_col][input_row],C5A0);
  if(input_color ==6) strcpy(color[input_col][input_row],C6A0);
  if(input_color ==7) strcpy(color[input_col][input_row],C7A0);
  recalc();
  print_screen();
}

if(input==2){
  printf("please enter row number > ");
  scanf("%d",&input_row);
  printf("Enter Column number 0=A,1=B,2=C,3=D,4=E,5=F,6=G,7=H,8=I,9=J... > ");
  scanf("%d",&input_col);
  printf("value of Row %d Column %d = %s'%s'%s \n",input_row,input_col,C2A0,valueo[input_col][input_row],C7A0);
  printf("type 0 and enter to continue.\n");
  scanf("%d",&input_row);
  print_screen();
}


if(input==3){

  printf("Enter filename to save to > ");
  scanf("%s",filenameout);
  printf("Enter name of book > ");
  scanf("%s",bookname);

  fileptr = fopen(filenameout, "w");

  // Write some text to the file
  
  fprintf(fileptr, "GSS1.0 112\n");
  fprintf(fileptr, "ssp %d %d %d %d %s\n",dp,cell_width,HLF,column_h,bookname);

  for(loopx=0;loopx<=93;loopx++){
    for(loopy=0;loopy<=93;loopy++){

      if(valueo[loopx][loopy][0] != '_'  && valueo[loopx][loopy][1] != '_' && valuen[loopx][loopy] !=1){
        fprintf(fileptr, "des %d %d 0 %d %s\n",loopx,loopy,valuec1[loopx][loopy],valueo[loopx][loopy]);
      }
      if(valueo[loopx][loopy][0] != '_'  && valueo[loopx][loopy][1] != '_' && valuen[loopx][loopy] ==1){
        fprintf(fileptr, "den %d %d 0 %d %s\n",loopx,loopy,valuec1[loopx][loopy],valueo[loopx][loopy]);
      }
  


    } //end loop y
  } //end loop x
  fprintf(fileptr,"stp 0 0 0 0 0\n");

  
  fclose(fileptr);// Close the file
  printf("File Witten!!\n");
  printf("type 0 and enter to continue.\n");
  scanf("%d",&input_row);
  print_screen();

}

if(input==5){
  dpage=dpage+1;
  print_screen();
}

if(input==6){
  dpage=dpage-1;
  print_screen();
}


if(input==7){
  printf("Please enter column head [0 for black backround with blue text] [1 for white background with blue text] > ");
  scanf("%d",&column_h);
  printf("Enter column (cell) width [6-11] > ");
  scanf("%d",&cell_width);
  recalc();
  print_screen();

}

if(input==0){
  exit(0);
}

} // end loop
return(0);

}
